{ ***********************    *********************** }

{ *** 餫  ᛘ Fotis.tpu *** }

 {  Fotis.tpu 夘  ᛘ  Turbo Pascal  ⮜ ᭦
 圪  㩜 (procedures - functions) 槦 夘 㩠
  ᧦  ᮤ ᣣ  Turbo Pascal.

  ᛘ Fotis.tpu 夞  ᮤ  椦  椦  棧
          1995   㣘
        ,  
  ੜ  ...2003!!! ᢢ   !

  ᨜      Fotis.tpu 㫘 ਠ⤞  9 
 ( Fotis1.tpu  Fotis9.tpu),    韞 梘  
   ᨮ 椦   ᛘ (Fotis.tpu)    ᝜
  ᢢ 9   㩜  櫘 .

 ᢢ  暦  ᩫ    暨  夘 竜
   , 竜   奜 ᫠,  椦  棧 
 殨 ᩡ    Turbo Pascal.

 ᤫ       ᧦ 椠,   
 ᢢ MS-DOS ( ᮫    暨), ⮜ 
    櫜  礫  
    ᢢ Windows. 뫩 椦 
 ''   奦      暨.
         暨   ⮘ 橣
  MS-DOS!!!
                                   髞
                             (c) 1995 - 2003
                                                                       }

Unit Fotis;
Interface
Uses Crt,Dos,Graph;

{ ***    ᣣ *** }

const
 floppynotinstalled=0;
 floppy360k=1;
 floppy1200k=2;
 floppy720k=3;
 floppy1440k=4;
 hexdigits:array[0..15] of char='0123456789ABCDEF';

{ ***  秦  ᣣ *** }

type binstr=string[8];
type str80=string[80];
type driveinfo=record
       levelinfo:integer;
       serialnum:longint;
       vollabel:array[1..11] of char;
       filesys:array[1..8] of char;
       reserved:array[1..64] of byte;
      end;
type serialnot=string[9];
type maxstr=string[255];

{ ***    ᣣ *** }

var fname,time_st,day_st,s2:string;
     ro,hidden,sys,vol,subdir,arch,error:boolean;
     ch,drive:char;
     month,year,day,hoyr,minute,second:word;
     diskerror:integer;
     oldint24:pointer;
     testfile:file;
     file1,file2,file3:str80;
     s:maxstr;
     hour,minutes,seconds:byte;

{ ***  圪 (procedures)  ᣣ *** }

{

1. ADD (⫝̸ 2 )
2. SUBSTRUCT ( 2 )
3. MULTIPLY (᝜ 2 )
4. DIVIDE ( 2 )
5. SWAPVARIABLES (᝜   2 )
6. SQUARE3 (᝜  ⤘    3  (礘))
7. SQUARE4 (᝜  ⤘    4  (礘))
8. SQUARE5 (᝜  ⤘    5  (礘))
9. SOUARE6 (᝜  ⤘    6  (礘))
10. BEEP (᚜ ᧦ 㮦)
11. PAUSE (⤜   ⤘ 㡫   婜)
12. PAUSEWITHMSG (⤜   ⤘ 㡫   婜 餦
      ⤘ 㤬)
13. PAUSECLS (⤜   ⤘ 㡫   婜  槠
     坜  椞)
14. PAUSEWITHMSGCLS (⤜   ⤘ 㡫   婜
     餦  ⤘ 㤬  槠 坜  椞)
15. BSAVE (餜   bsave  Basic)
16. BLOAD (餜   bload  Basic)
17. NOSPACEATEND (  ᧦ string    ⢦)
18. CHECKGROK (ᤜ ⢜ 垩 )
19. CIRCLEDEMO (᝜ ᭦ 箨ࣦ 硢)
20. PRINTDRIVES ( 餜  Disk Drives ⮦  /   秦 夘
     ..  5 1/4  3 1/2)
21. PRINTXMS ( 室 橞 㣞 XMS ⮦ 矜)
22. DRAWRANDOMPIXELS (᝜    pixels)
23. DRAWRANDOMPOLY (᝜    घ)
24. MERGE (ज眠 2   ⤘)
25. GETFILEATTRIBUTES ( 室  櫞 ᧦ 妬)
26. SETFILEATTRIBUTES (ᝦ  櫞  ᧦ )
27. GETFILETIMEANDDATE ( 室     騘 
     㟞 ᧦ )
28. SETFILETIMEANDDATE (ᝦ  騘     ⤘ )
29. EXITTODOS (坜   ᝜  Dos Prompt)
30. GETSYSTEMDATE ( 室    㣘)
31. SETSYSTEMDATE (ᝦ    㣘)
32. GETSYSTEMTIME ( 室  ⮦ 騘  㣘)
33. SETSYSTEMTIME (ᝦ  騘  㣘) }

procedure add(a,b:integer);
procedure substruct(a,b:integer);
procedure multiply(a,b:integer);
procedure divide(a,b:integer);
procedure swapvariables(var a,b:integer);
procedure square3(var k:integer);
procedure square4(var k:integer);
procedure square5(var k:integer);
procedure square6(var k:integer);
procedure beep(f,t:integer);
procedure pause;
procedure pausewithmsg;
procedure pausecls;
procedure pausewithmsgcls;
procedure bsave(filename:string;address:pointer;l:word);
procedure bload(filename:string;address:pointer);
procedure nospaceatend(var s:maxstr);
procedure checkgrok;
procedure circledemo;
procedure removecurrentdir;
procedure printdrivetype(typecode:byte);
procedure printdrives0;
procedure printdrives;
procedure printxms;
procedure drawrandompixels;
procedure drawrandompoly;
procedure merge(fname1,fname2,fname3:str80);
procedure ff_getfileattributes(filename:string;var ro,hidden,
 sys,vol,subdir,arch,error:boolean);
procedure getfileattributes;
procedure ff_setfileattributes(filename:string;var ro,hidden,
 sys,arch:boolean);
procedure setfileattributes;
procedure closefilehandle(i:integer);
procedure ff_getfiletimeanddate(filename:string;var time_st,day_st:string;
 var error:boolean);
procedure getfiletimeanddate;
procedure ff_setfiletimeanddate(filename:string;month,day,year,hour,minute,
 second:word;var error:boolean);
procedure setfiletimeanddate;
procedure exittodos;
procedure ff_getsystemdate(var date:string);
procedure getsystemdate;
procedure ff_setsystemdate(month,day,year:integer;var error:boolean);
procedure setsystemdate;
procedure ff_getsystemtime(var time:string);
procedure getsystemtime;
procedure ff_setsystemtime(hour,minute,second:byte;var error:boolean);
procedure setsystemtime;

{ ***  㩜 (functions)  ᣣ *** }

{

1.  GETSERIALNUMBER ( 室  serial number  ⫝̸   
     婡)
2. INVERSE ( ⭜ ⤘ string 婫)
3. BINARYDIGIT ( ⭜        驘)
4. DELTREE (ᤜ 櫠    deltree  Ms-Dos, ᭜ 
    暦  )         }

function getserialnumber(drive:integer):serialnot;
function inverse(lexi:string):string;
function binarydigit(b:byte):binstr;
function deltree(dirname:string):integer;
function getfilehandle(filename:string;var error:boolean):integer;
function readcmos(address:byte):byte;

Implementation

{ ***   add *** }

procedure add(a,b:integer);
 var c:integer;
 begin
 c:=a+b;
 writeln(c);
 end;

{ ***   substruct *** }

procedure substruct(a,b:integer);
 var c:integer;
 begin
 c:=a-b;
 writeln(c);
 end;

{ ***   multiply *** }

procedure multiply(a,b:integer);
 var c:integer;
 begin
 c:=a*b;
 writeln(c);
 end;

{ ***   divide *** }

procedure divide(a,b:integer);
 var c:real;
 begin

 c:=a/b;
 writeln(c);
 end;

{ ***   swapvariables *** }

procedure swapvariables(var a,b:integer);
 var c:integer;
 begin
 c:=a;
 a:=b;
 b:=c;
 end;

{ ***   square3 *** }

procedure square3(var k:integer);
 begin
 k:=k*k*k;
 writeln(k);
 end;


{ ***   square4 *** }

procedure square4(var k:integer);
 begin
 k:=k*k*k*k;
 writeln(k);
 end;

{ ***   square5 *** }

procedure square5(var k:integer);
 begin
 k:=k*k*k*k*k;
 writeln(k);
 end;

{ ***   square6 *** }

procedure square6(var k:integer);
 begin
 k:=k*k*k*k*k*k;
 writeln(k);
 end;

{ ***   beep *** }

procedure beep(f,t:integer);
 begin
 sound(f);
 delay(t);
 nosound;
 end;

{ ***   pause *** }

procedure pause;
 begin
 repeat until keypressed;
 end;

{ ***   pausewithmsg *** }

procedure pausewithmsg;
 begin
 gotoxy(25,24);
 writeln('Press any key to continue . . . ');
 repeat until keypressed;
 end;

{ ***   pausecls *** }

procedure pausecls;
 begin
 repeat until keypressed;
 clrscr;
 end;


{ ***   pausewithmsgcls *** }

procedure pausewithmsgcls;
 begin
 gotoxy(25,24);

 writeln('Press any key to continue . . .');
 repeat until keypressed;
 clrscr;
 end;

{ ***   bsave *** }

procedure bsave(filename:string;address:pointer;l:word);
 var f:file;
 x:word;
 b:byte;
 begin
 assign(f,filename);
 rewrite(f,1);
 b:=$fd;
 blockwrite(f,b,1);
 x:=seg(address^);
 blockwrite(f,x,2);
 x:=ofs(address^);
 blockwrite(f,x,2);
 blockwrite(f,l,2);
 blockwrite(f,address^,l);
 close(f);
 end;

{ ***   bload *** }

procedure bload(filename:string;address:pointer);
 var f:file;
 b:byte;
 segment,ofset,l:word;
 begin
 assign(f,filename);
 reset(f,1);
 blockread(f,b,1);
 if (b<>$fd) then
 begin
 writeln('   夘 .');
 exit;
 end;
 blockread(f,segment,2);
 blockread(f,ofset,2);
 blockread(f,l,2);
 if (address=nil) then address:=ptr(segment,ofset);
 blockread(f,address^,l);
 close(f);
 end;

{ ***   nospaceatend *** }

procedure nospaceatend(var s:maxstr);
 begin
 while (s[length(s)]=' ')do
 delete(s,length(s),1);
 end;

{ ***   checkgrok *** }

procedure checkgrok;
 begin
 if(graphresult<>grok) then
 begin
 writeln('♞ ᢣ  : ',grapherrormsg(graphresult));
 writeln(' 暨 坜.');
 readln;
 halt;
 end;
 end;

{ ***   circledemo *** }

procedure circledemo;
 var palette:palettetype;
 maxx,maxy,i,errorcode,graphmode,graphdriver:integer;
 size:word;
 p:pointer;
 begin
 graphdriver:=detect;
 initgraph(graphdriver,graphmode,'c:\dos1\tp');
 errorcode:=graphresult;
 if errorcode <> grok then
 begin
 writeln('ᢣ  : ',grapherrormsg(errorcode));
 halt;
 end;
 maxx:=getmaxy;
 maxy:=getmaxy;
 line(maxx div 2,0,maxx div 2,maxy);
 line(0,maxy div 2,maxx,maxy div 2);
 line(0,0,maxx,maxy);
 line(maxx,0,0,maxy);

 i:=maxy;
 while i > 20 do
 begin
 circle(maxx div 2,maxy div 2,i);
 i:=i-10;
 end;
 size:=imagesize(round(maxx*0.25),round(maxy*0.25),
 round(maxx*0.75),round(maxy*0.75));
 getmem(p,size);
 getimage(round(maxx*0.25),round(maxy*0.25),
 round(maxx*0.75),round(maxy*0.75),p^);
 for i:=1 to 6 do
 begin
 putimage(round(maxx*0.25),round(maxy*0.25),p^,notput);
 getimage(round(maxx*0.25),round(maxy*0.25),
 round(maxx*0.75),round(maxy*0.75),p^);
 end;
 getpalette(palette);
 repeat
 setfillstyle(random(9),random(palette.size)+1);
 floodfill(random(maxx),random(maxy),white);
 until keypressed;
 readln;
 closegraph;
 end;


{ ***   removecurrentdir ( ) *** }

procedure removecurrentdir;
 var
 searcher:searchrec;
 f:file;
 begin
 {$I-}
 findfirst('*.*',$37,searcher);
 while (doserror = 0 ) do
 begin
 if ((searcher.attr and directory)<>0)
 then begin
 if ((searcher.name<>'.') and
 (searcher.name <> '..')) then begin
 chdir(searcher.name);
 removecurrentdir;
 chdir('..');
 rmdir(searcher.name);
 if (ioresult <> 0) then
 begin
 writeln('      : ',searcher.name);
 halt;
 end;
 end;
 end
 else begin
 assign(f,searcher.name);
 erase(f);
 if (ioresult<>0) then
 begin
 writeln('      : ',searcher.name);
 halt;
 end;
 end;
 findnext(searcher);

 end;
 end;

{ ***   printdrivetype ( ) *** }

procedure printdrivetype(typecode:byte);
 begin
 case (typecode) of
  floppynotinstalled:writeln(' ᨮ  ⫫.');
  floppy360k:writeln('5 1/4"  櫞(360Kb)');
  floppy1200k:writeln('5 1/4  櫞(1200Kb)');
  floppy720k:writeln('3 1/2  櫞(720Kb)');
  floppy1440k:writeln('3 1/2  櫞(1.44Mb)');
  end;
  end;

{ ***   printdrives0 ( ) *** }

procedure printdrives0;
 var cmosdriveval:byte;
 begin
 cmosdriveval:=readcmos($10);
 write('ᛘ :');
 printdrivetype(cmosdriveval shr 4);
 write('ᛘ B:');
 printdrivetype(cmosdriveval and $0f);
 end;

{ ***   printdrives *** }

procedure printdrives;
 begin
 printdrives0;
 end;

{***   printxms ***}

procedure printxms;
 var memoryamount:word;
 begin
 memoryamount:=readcmos($18);
 memoryamount:=memoryamount shl 8;
 memoryamount:=memoryamount or readcmos($18);
 writeln('ᨮ ',memoryamount,'Kb 㣞 XMS');
 end;

{ ***   drawrandompixels *** }

procedure drawrandompixels;
 var maxx,maxy,x,y,errorcode,graphmode,graphdriver:integer;
 begin
 graphdriver:=detect;
 initgraph(graphdriver,graphmode,'c:\dos1\tp6');
 errorcode:=ioresult;
 if (errorcode<>grok) then
 begin
 writeln('ᢣ  : ',grapherrormsg(errorcode));
 halt;
 end;
 maxx:=getmaxx;
 maxy:=getmaxy;
 repeat
 x:=random(maxx+1);
 y:=random(maxy+1);
 putpixel(x,y,white);
 delay(3000);
 until keypressed;
 closegraph;
 end;

{ ***   drawrandompoly *** }

procedure drawrandompoly;
 type tritype=array[1..3] of pointtype;
 var tri:tritype;
 s:string;
 maxx,maxy,x1,y1,graphdriver,i,j,k,errorcode,graphmode:integer;
 palette:palettetype;
 a:longint;
 begin
 graphdriver:=detect;
 initgraph(graphdriver,graphmode,'c:\dos1\tp6');
 errorcode:=ioresult;
 if (errorcode<>grok) then
 begin
 writeln('ᢣ  : ',grapherrormsg(errorcode));
 halt;
 end;
 maxx:=getmaxx;
 maxy:=getmaxy;
 getpalette(palette);
 setfillstyle(3,3);
 while not keypressed do
 begin
 setfillstyle(random(13),random(palette.size)+1);
 tri[1].x:=random(maxx);
 tri[1].y:=random(maxy);
 tri[2].x:=random(maxx);
 tri[2].y:=random(maxy);
 tri[3].x:=random(maxx);
 tri[3].y:=random(maxy);
 fillpoly(3,tri);
 for a:=1 to 200000 do
 begin
 delay(6000);
 delay(6000);
 delay(6000);
 delay(6000);
 delay(6000);
 end;
 x1:=x1+(maxx div 12);
 y1:=y1+(maxy div 12);
 end;
 closegraph;
 end;

{ ***   merge *** }

procedure merge(fname1,fname2,fname3:str80);
 var ok1,ok2:boolean;
 f1,f2,f3:text;
 i1,i2:integer;

{ ***  ᨫ getitem1 ( ᨫ *** }

function getitem1(var i:integer):boolean;
 begin
 if not eof(f1) then
 begin
 readln(f1,i);
 getitem1:=true;
 end else getitem1:=false;
 end;

{ ***  ᨫ getitem2 ( ᨫ *** }

function getitem2(var i:integer):boolean;
 begin
 if not eof(f2) then
 begin
 readln(f2,i);
 getitem2:=true;
 end else getitem2:=false;
 end;
 begin
 assign(f1,fname1);
 reset(f1);
 assign(f2,fname2);
 reset(f2);
 assign(f3,fname3);
 rewrite(f3);
 ok1:=getitem1(i1);
 ok2:=getitem2(i2);
 while ok1 or ok2 do
 begin
 if ok1 and ok2 then
 begin
 if i1<i2 then
 begin
 writeln(f3,i1);
 ok1:=getitem1(i1);
 end else if ok2 then
 begin
 writeln(f3,i2);
 ok2:=getitem2(i2);
 end;
 end;
 close(f1);

 close(f2);
 close(f3);
 end;
 end;

{ ***   closefilehandle ( ) *** }

procedure closefilehandle(i:integer);
 var regs:registers;
 begin
 with regs do
 begin
 AH:=$3E;
 BX:=i;
 end;
 msdos(regs);
 end;

{ ***  ᨫ getfilehandle ( ᨫ) *** }

function getfilehandle(filename:string;var error:boolean):integer;
 var regs:registers;
 i:integer;
 begin
 filename:=filename+#0;
 fillchar(regs,sizeof(regs),0);
 with regs do
 begin
 AH:=$3D;
 AL:=$00;
 DS:=seg(filename);
 DX:=ofs(filename)+1;
 end;
 msdos(regs);
 i:=regs.AX;
 if (lo(regs.flags)and $01)>0 then
 begin
 error:=true;
 getfilehandle:=0;
 exit;
 end;
 getfilehandle:=i;
 end;

{ ***   ff_getfileattributes ( ) *** }

procedure ff_getfileattributes(filename:string;var ro,hidden,
 sys,vol,subdir,arch,error:boolean);
 var regs:registers;
 begin
 fillchar(regs,sizeof(regs),0);
 filename:=filename+#0;
 with regs do
 begin
 AH:=$43;
 DS:=seg(filename);
 DX:=ofs(filename)+1;
 end;
 msdos(regs);
 error:=(regs.AL in [2,3,5]);
 ro:=(regs.CL and $01)>0;
 hidden:=(regs.CL and $02)>0;
 sys:=(regs.CL and $04)>0;

 vol:=(regs.CL and $08)>0;
 subdir:=(regs.CL and $10)>0;
 arch:=(regs.CL and $20)>0;
 end;

{ ***   getfileattributes *** }

procedure getfileattributes;
 begin
 writeln('驫  椦  妬 : ');
 readln(fname);
 ff_getfileattributes(fname,ro,hidden,sys,vol,subdir,arch,error);
 if error then
 writeln('៦ !')else begin
 writeln('  ',fname,'⮜   櫞 : ');
 writeln('椦 ᚤਫ਼ : ',ro);
 writeln('⤦ : ',hidden);
 writeln(' 㣘 : ',sys);
 writeln('⫘ ᛘ : ',vol);
 writeln('ᢦ : ',subdir);
 writeln('⫞ : ',arch);
 end;
 end;

{ ***   ff_setfileattributes ( ) *** }

procedure ff_setfileattributes(filename:string;var ro,hidden,
 sys,arch:boolean);
 var regs:registers;
 begin
 fillchar(regs,sizeof(regs),0);
 filename:=filename+#0;
 with regs do
 begin
 AH:=$43;
 AL:=1;
 DS:=seg(filename);
 DX:=ofs(filename)+1;
 if ro then
 CL:=(CL or $01);
 if hidden then
 CL:=(CL or $02);
 if sys then
 CL:=(CL or $04);
 if arch then
 CL:=(CL or $20);
 end;
 msdos(regs);
 end;

{ ***   setfileattributes *** }

procedure setfileattributes;
 begin
 writeln('驫  椦  妬 : ');
 readln(fname);
 write('椦 ᚤਫ਼ ?(/) : ');
 readln(ch);
 ro:=upcase(ch)='N';
 write('댎 ?(/) : ');
 readln(ch);
 hidden:=upcase(ch)='N';
 write('A⫞ ?(N/O) : ');
 readln(ch);
 arch:=upcase(ch)='N';
 write(' 㣘 ?(N/O) : ');
 readln(ch);
 sys:=upcase(ch)='N';
 ff_setfileattributes(fname,ro,hidden,sys,arch);
 writeln('  ',fname,'⮜   櫞 : ');
 writeln('椦 ᚤਫ਼ : ',ro);
 writeln('⤦ : ',hidden);
 writeln(' 㣘 : ',sys);
 writeln('ᢦ : ',subdir);
 writeln('⫞ : ',arch);
 end;

{ ***   ff_getfiletimeanddate ( ) *** }

procedure ff_getfiletimeanddate(filename:string;var time_st,day_st:string;
 var error:boolean);
 var regs:registers;
 i:integer;
 st1,st2,st3:string[4];
 y,m,d,r,h,s,time,day:word;
 begin
 error:=false;
 time_st:=' ';
 day_st:=' ';
 i:=getfilehandle(filename,error);
 if error then exit;
 with regs do
 begin
 AH:=$57;
 AL:=$00;
 BX:=i;
 end;
 msdos(regs);
 closefilehandle(i);
 r:=regs.CX;
 h:=r div 2048;
 r:=r -(h*2048);
 m:=r div 32;
 r:=r-(m*32);
 s:=r*2;
 str(h:0,st1);
 str(m:0,st2);
 str(s:0,st3);
 if length(st1)=1 then st1:='0'+st1;
 if length(st2)=1 then st2:='0'+st2;
 if length(st3)=1 then st3:='0'+st3;
 time_st:=st1+':'+st2+':'+st3;
 r:=regs.DX;
 y:=(r div 512)+1980;
 r:=r-((y-1980)*512);
 m:=r div 32;
 r:=r-(m*32);
 d:=r;
 str(y:0,st1);
 str(m:0,st2);
 str(d:0,st3);
 if length(st1)=1 then st1:='0'+st1;
 if length(st2)=1 then st2:='0'+st2;
 if length(st3)=1 then st3:='0'+st3;
 day_st:=st2+'-'+st3+'-'+st1;
 end;

{ ***   getfiletimeanddate *** }

procedure getfiletimeanddate;
 begin
 ff_getfiletimeanddate(fname,time_st,day_st,error);
 if error then writeln('៦ !') else
 writeln(time_st,' ',day_st);
 end;

{ ***   ff_setfiletimeanddate ( ) *** }

procedure ff_setfiletimeanddate(filename:string;month,day,year,hour,minute,
 second:word;var error:boolean);
 var regs:registers;
 i,j,k,t,d:word;
 begin
 error:=false;
 i:=getfilehandle(filename,error);
 if error then exit;
 t:=((hour*2048)+(minute*32)+second div 2);
 d:=((year-1980)*512)+(month*32)+day;
 with regs do
 begin
 AH:=$57;
 AL:=$01;
 BX:=i;
 CX:=t;
 DX:=d;
 end;
 msdos(regs);
 closefilehandle(i);
 end;

{ ***   setfiletimeanddate *** }

procedure setfiletimeanddate;
 var hour:word;
 begin
 write(' : ');
 readln(fname);
 write('㤘 : ');
 readln(month);
 write('⨘ : ');
 readln(day);
 write('뫦 : ');
 readln(year);
 write(' : ');
 readln(hour);
 write(' : ');
 readln(minute);
 write('梜 : ');
 readln(second);
 ff_setfiletimeanddate(fname,month,day,year,hour,minute,second,error);
 ff_getfiletimeanddate(fname,time_st,day_st,error);
 if error then writeln('៦ !') else writeln(time_st,' ',day_st);
 end;

{ ***   exittodos *** }

procedure exittodos;
 begin
 halt;
 end;

{ ***   ff_getsystemdate ( ) *** }

procedure ff_getsystemdate(var date:string);
 var regs:registers;
 st1,st2,st3,st4:string[10];
 begin
 fillchar(regs,sizeof(regs),0);
 regs.AH:=$2A;
 msdos(regs);
 with regs do
 begin
 case AL of
 0:st1:='';
 1:st1:='⨘';
 2:st1:='嫞';
 3:st1:='ᨫ';
 4:st1:='⣫';
 5:st1:='';
 6:st1:='᫦';
 end;
 str(CX,st2);
 str(DH,st3);
 str(DL,st4);
 end;
 if length(st3)=1 then st3:='0'+st3;
 if length(st4)=1 then st4:='0'+st4;
 date:=st1+' '+st4+' '+st3+' '+st2;
 end;


{ ***   getsystemdate *** }

procedure getsystemdate;
 begin
 ff_getsystemdate(s2);
 writeln('  夘 : ',s2);
 end;

{ ***   ff_setsystemdate ( ) *** }

procedure ff_setsystemdate(month,day,year:integer;var error:boolean);
 var regs:registers;
 begin
 fillchar(regs,sizeof(regs),0);
 with regs do
 begin
 AH:=$2B;
 DH:=Month;
 DL:=Day;
 CX:=Year;
 end;
 msdos(regs);
 error:=regs.AL<>0;
 end;

{ ***   setsystemdate *** }

procedure setsystemdate;
 var minas,imera,etos:integer;
 begin
 write('驜 㤘 : ');
 readln(minas);
 write('驜 ⨘ : ');
 readln(imera);
 write ('驜 ⫦ : ');
 readln(etos);
 ff_setsystemdate(minas,imera,etos,error);
 if error then writeln('៦ !!!') else writeln('  婟.');
 end;

{ ***   ff_getsystemtime ( ) *** }

procedure ff_getsystemtime(var time:string);
 var regs:registers;
 h,m,s:word;
 st1,st2,st3,st4:string[10];
 begin
 fillchar(regs,sizeof(regs),0);
 regs.AH:=$2C;
 msdos(regs);
 with regs do
 begin
 str(CH,st1);
 str(CL,st2);
 str(DH,st3);
 str(DL,st4);
 end;
 if length(st1)=1 then st1:='0'+st1;
 if length(st2)=1 then st2:='0'+st2;
 if length(st3)=1 then st3:='0'+st3;
 if length(st4)=1 then st4:='0'+st4;
 time:=st1+':'+st2+':'+st3+':'+st4;
 end;

{ ***   getsystemtime *** }

procedure getsystemtime;
 begin
 ff_getsystemtime(s2);
 writeln(' 騘 夘 : ',s2);
 end;

{ ***   ff_setsystemtime ( ) *** }

procedure ff_setsystemtime(hour,minute,second:byte;var error:boolean);
 var regs:registers;
 begin
 fillchar(regs,sizeof(regs),0);

 with regs do
 begin
 AH:=$2D;
 CH:=Hour;
 CL:=Minute;
 DH:=Second;
 end;
 msdos(regs);
 error:=regs.AL <> 0;
 end;

{ ***   setsystemtime *** }

procedure setsystemtime;
 begin
 write('驜 ਘ : ');
 readln(hour);
 write('驜  : ');
 readln(minute);
 write('驜 梜 : ');
 readln(second);
 ff_setsystemtime(hour,minute,second,error);
 ff_getsystemtime(s2);
 writeln(' 騘 夘 : ',s2);
 end;

{ ***  ᨫ readcmos ( ᨫ) *** }

function readcmos(address:byte):byte;
 var result:byte;
 begin
 port[$70]:=address;
 result:=0;
 result:=0;
 result:=port[$71];
 readcmos:=result;
 end;

{ ***  ᨫ getserialnumber *** }

function getserialnumber(drive:integer):serialnot;
 var
 buffer:string[10];
 info:driveinfo;
 r:registers;
 i:integer;
 begin
 r.ax:=$6900;
 r.bl:=drive;
 r.dx:=ofs(info);
 r.ds:=seg(info);
 intr($21,r);
 if ((r.flags and 1)=1) then
 buffer:=''
 else
 begin
 buffer:='';
 for i:=1 to 8 do

 begin
 buffer:=
 hexdigits[info.serialnum and $0f]+buffer;
 info.serialnum:=info.serialnum shr 4;
 if (i=4) then
 buffer:='-' + buffer;
 end;
 end;
 getserialnumber:=buffer;
 end;

{ ***  ᨫ inverse *** }

function inverse(lexi:string):string;
 var i:integer;
 apot:string;
 begin
 apot:='';
 for i:=length(lexi) downto 1 do
 apot:=apot+lexi[i];
 inverse:=apot;
 end;

{ ***  ᨫ binarydigit *** }

function binarydigit(b:byte):binstr;
 var i:integer;
 bt:byte;
 s:binstr;
 begin
 bt:=$01;
 s:=' ';
 for i:=1 to 8 do
 begin
 if (b and bt)>0 then s:='1'+s else s:='0'+s;
 bt:=bt shl 1;
 end;
 binarydigit:=s;
 end;

{ ***  ᨫ deltree *** }

function deltree(dirname:string):integer;
 var
 curdir:string;
 begin
 getdir( 0,curdir);
 {$I-}
 chdir(dirname);
 if (ioresult<>0) then
 begin
 writeln('    : ',dirname);
 deltree:=-1;
 exit;
 end;
 removecurrentdir;
 chdir('..');
 chdir(curdir);
 rmdir(dirname);
 deltree:=0;
 {$I+}
 end;

end.

{ ********************    ******************** }
